# [[

> Verifica tipos de arquivos e compara valores.
> Retorna 0 se a condição é verdadeira, 1 se a condição é falsa.
> Mais informações: <https://gnu.org/software/bash/manual/bash.html#index-_005b_005b>.

- Testa se uma determinada variável é igual/diferente a uma determinada string:

`[[ ${{variável}} {{==|!=}} "{{string}}" ]]`

- Testa se uma determinada string está em conformidade com um determinado padrão/regex:

`[[ ${{variável}} {{==|=~}} {{padrão}} ]]`

- Testa se uma determinada variável é igual [eq]/não igual [ne]/maior que [gt]/menor que [lt]/maior ou igual que [ge]/menor ou igual que [le] um determinado número:

`[[ ${{variável}} -{{eq|ne|gt|lt|ge|le}} {{número}} ]]`

- Testa se uma determinada variável tem um valor [n]ão vazio:

`[[ -n ${{variável}} ]]`

- Testa se determinada variável tem um valor va[z]io:

`[[ -z ${{variável}} ]]`

- Testa se um determinado arquivo exite[f]:

`[[ -f {{caminho/para/arquivo}} ]]`

- Testa se um determinado [d]iretório existe:

`[[ -d {{caminho/para/diretório}} ]]`

- Testa se um determinado arquivo ou diretório [e]xiste:

`[[ -e {{caminho/para/arquivo_ou_diretório}} ]]`
